(function(exports) {
    exports.main = async function() {
        await request_status()
        .then(values => {
            let status = values[0]
            //console.log(status)

            if (status != 255)
            {
                let h3 = `<h3 id="UserApp">${l100n.localize_string('appsw_Application_header')}</h3>`

                //let description_header = '<div class="accordion-header">Application SW Description</div>'
                //let description_body = $('<div>').addClass("accordion-body")
                let control_header = `<div class="accordion-header">${l100n.localize_string('appsw_Application_control')}</div>`
                let control_body = $('<div>').addClass("accordion-body")
                let table = $('<table>')
                table.append(form_tag_tr_param_class({name: l100n.localize_string('appsw_Project Name'), index: 0x5000, sub: 1}))
                table.append(form_tag_tr_param_class({name: l100n.localize_string('appsw_Project Build Date'), index: 0x5000, sub: 2}))
                table.append(form_tag_tr_param_class({name: l100n.localize_string('appsw_Project Version'), index: 0x5000, sub: 3}))
                table.append(form_tag_tr_param_class({name: l100n.localize_string('appsw_Checksum'), index: 0x5000, sub: 4}))
                //description_body.append(table)
                

                
                //table = $('<table>')
                table.append(form_tag_tr_param_class({name: l100n.localize_string('appsw_Status'), index: 0x5001, sub: 1}))

                const eds_script = utils.load_script('eds.js')
                Promise.all([
                    eds_script
                ])
                .then(() => eds.get_eds_object())	
                .then(eds_object => {
                    if ("5002" in eds_object)
                    {
                        if (eds_object[5002].subs[1].AccessType.includes('w'))
                        {
                            let start_button = ($(`<input type="submit" value="${l100n.localize_string("ua_start")}" id="start_button">`))
                            let stop_button = ($(`<input type="submit" value="${l100n.localize_string("ua_stop")}" id="stop_button">`))
                            let debug_button = ($(`<input type="submit" value="${l100n.localize_string("ua_debug")}" id="debug_button">`))
                            let button_tr = $('<tr>')
                                .append($('<td>').text(l100n.localize_string("Control")))
                                .append($('<td>').append(start_button).append(stop_button).append(debug_button))
                            table.append(button_tr)
                        }
                    }
                })

                control_body.append(table)
                
                $("#app_sw_div").append(h3).append(control_header).append(control_body)
                //$("#app_sw_div").append(description_header).append(description_body)

                //let user_html_page = $('<div>')
                //user_html_page.load("app_sw.html")
                //$("#app_sw_div").append(user_html_page)
            }
        })
    }

    function request_status()
    {
        let query = '/get_od_data.form?'
	    query += `0x5001_1`
        return fetch(query)
            .then(response => response.text())
            .then(response_text => common.response_ready(response_text))
    }

    function form_tag_tr_param_class(param) //param.name, param.index, param.sub
    {
        let td = $('<td>').addClass('name').text(param.name)
        let tr = $('<tr class="can_hide">').append(td)//.addClass("name"));
        let div = $('<div>').addClass("accordion_tag").attr({"index": `${param.index.toString(16).toUpperCase()}:${param.sub}`});
        tr.append($('<td>').append(div))//.addClass("name"));
        return tr;
    }

    let button_command_xhr = new XMLHttpRequest()
    $(document).on('click', '#stop_button', function()
    {
        let query = `/set_od_data.form?0x5002_1=2`;
        button_command_xhr.open('GET', query, true);
        button_command_xhr.send();
    })
    $(document).on('click', '#start_button', function()
    {
        let query = `/set_od_data.form?0x5002_1=1`;
        button_command_xhr.open('GET', query, true);
        button_command_xhr.send();
    })
    $(document).on('click', '#debug_button', function()
    {
        let query = `/set_od_data.form?0x5002_1=3`;
        button_command_xhr.open('GET', query, true);
        button_command_xhr.send();
    })
})(this.app_sw_control = {})